/*!
  @author Shin'ichiro Nakaoka
*/

#ifndef CNOID_UTIL_PYUTIL_H
#define CNOID_UTIL_PYUTIL_H

#include <cnoid/Config>

/**
   This header includes several pybind11 headers such as stl.h and eigen.h, which handle
   the type conversion between C++ and Python. Such files define the specializations of
   the type_caster template. In the pybind11 specification, the specializations used in
   some implementation files in a python module must be defined in all the implementation
   files in the module to use the unified specializations in the modulee. Otherwise a
   compilation warning will be generated and some problems may occur. (In fact the warning
   is generated by GCC.) To avoid the problem, the headers used in some implementation
   files are included in this header file and the header file is included from all the
   implementation files.
*/

#include "PyReferenced.h"
#include "PySignal.h"
#include "PyEigenTypes.h"
#include <pybind11/stl.h>

namespace cnoid { namespace python {
using namespace pybind11;
}}

#endif
