macro(choreonoid_find_qt_msvc_cmake_prefix_paths qt_major_version prefix_paths)
  unset(qt_msvc_vers)
  list(APPEND qt_msvc_vers 2015)
  if(MSVC_VERSION GREATER_EQUAL 1910) # VC++2017 or later
    list(PREPEND qt_msvc_vers 2017)
  endif()
  if(MSVC_VERSION GREATER_EQUAL 1920) # VC++2019 or later
    list(PREPEND qt_msvc_vers 2019)
  endif()
  if(MSVC_VERSION GREATER_EQUAL 1930) # VC++2022 or later
    list(PREPEND qt_msvc_vers 2022)
  endif()

  if(${qt_major_version} EQUAL 6)
    set(qt_dir_pattern "c:/Qt/6.*.*")
    set(qt_cmake_dir_pattern "?:/Qt/6.*.*/msvc20??_64/lib/cmake")
  else()
    set(qt_dir_pattern "c:/Qt/5.*.*")
    set(qt_cmake_dir_pattern "?:/Qt/5.*.*/msvc20??_64/lib/cmake")
  endif()

  file(GLOB qt_dirs "${qt_dir_pattern}")
  list(REVERSE qt_dirs)
  unset(qt_cmake_dirs)
  foreach(qt_msvc_ver ${qt_msvc_vers})
    foreach(qt_dir ${qt_dirs})
      set(qt_cmake_dir "${qt_dir}/msvc${qt_msvc_ver}_64/lib/cmake")
      if(EXISTS ${qt_cmake_dir})
	list(APPEND qt_cmake_dirs ${qt_cmake_dir})
      endif()
    endforeach()
  endforeach()
  if(NOT qt_cmake_dirs)
    file(GLOB qt_cmake_dirs ${qt_cmake_dir_pattern})
    list(REVERSE qt_cmake_dirs)
  endif()

  set(${prefix_paths} ${qt_cmake_dirs})
endmacro()

macro(choreonoid_find_qt_package)
  if(${ARGC} EQUAL 0)
    if(CHOREONOID_QT_MAJOR_VERSION EQUAL 6)
      set(components Core Gui Widgets OpenGLWidgets Network Svg)
    else()
      set(components Core Gui Widgets Network Svg)
    endif()
  else()
    set(components ${ARGV})
  endif()

  if(UNIX)
    if(CHOREONOID_QT_MAJOR_VERSION EQUAL 5)
      cmake_policy(PUSH)
      if(NOT POLICY CMP0057)
	message(FATAL_ERROR "Choreonoid requires the IN_LIST operator")
      endif()
      cmake_policy(SET CMP0057 NEW)
      if("Gui" IN_LIST components)
	list(APPEND components X11Extras)
      endif()
      cmake_policy(POP)
    endif()
  elseif(MSVC)
    choreonoid_find_qt_msvc_cmake_prefix_paths(
      CHOREONOID_QT_MAJOR_VERSION qt_cmake_prefix_paths)
  endif()

  if(CHOREONOID_QT_MAJOR_VERSION EQUAL 6)
    find_package(Qt6 REQUIRED COMPONENTS ${components} HINTS ${qt_cmake_prefix_paths})
    foreach(component ${components})
      list(APPEND libs "Qt6::${component}")
    endforeach()
    set(CHOREONOID_QT_CORE_LIBRARY Qt6::Core)
    get_filename_component(prefix1 "${Qt6_DIR}" DIRECTORY)
    get_filename_component(prefix2 "${prefix1}" DIRECTORY)
    get_filename_component(QT_INSTALL_PREFIX "${prefix2}" DIRECTORY)

  elseif(CHOREONOID_QT_MAJOR_VERSION EQUAL 5)
    find_package(Qt5 REQUIRED COMPONENTS ${components} HINTS ${qt_cmake_prefix_paths})
    foreach(component ${components})
      list(APPEND libs "Qt5::${component}")
    endforeach()
    set(CHOREONOID_QT_CORE_LIBRARY Qt5::Core)
    get_filename_component(prefix1 "${Qt5_DIR}" DIRECTORY)
    get_filename_component(prefix2 "${prefix1}" DIRECTORY)
    get_filename_component(QT_INSTALL_PREFIX "${prefix2}" DIRECTORY)
  endif()

  set(CHOREONOID_QT_LIBRARIES ${libs})
  set(CHOREONOID_QT_COMPILE_DEFINITIONS QT_NO_KEYWORDS QT_NO_OPENGL_ES_2)
endmacro()

macro(choreonoid_qt_wrap_cpp)
  if(CHOREONOID_QT_MAJOR_VERSION EQUAL 6)
    qt6_wrap_cpp(${ARGV})
  elseif(CHOREONOID_QT_MAJOR_VERSION EQUAL 5)
    qt5_wrap_cpp(${ARGV})
  else()
    qt_wrap_cpp(${ARGV})
  endif()
endmacro()

macro(choreonoid_qt_wrap_ui)
  if(CHOREONOID_QT_MAJOR_VERSION EQUAL 6)
    qt6_wrap_ui(${ARGV})
  elseif(CHOREONOID_QT_MAJOR_VERSION EQUAL 5)
    qt5_wrap_ui(${ARGV})
  else()
    qt_wrap_ui(${ARGV})
  endif()
endmacro()

macro(choreonoid_qt_add_resources)
  if(CHOREONOID_QT_MAJOR_VERSION EQUAL 6)
    qt6_add_resources(${ARGV})
  elseif(CHOREONOID_QT_MAJOR_VERSION EQUAL 5)
    qt5_add_resources(${ARGV})
  else()
    qt_add_resources(${ARGV})
  endif()
endmacro()
