![logo](misc/logo/logo1.svg)

---

Choreonoid is an open-source, lightweight, and extensible integrated graphical framework for robot development. You can develop your robots with various functions and resources of Choreonoid.

# Functions

## Model Visualization

Choreonoid works as a visualization tool. The provided GUI tools support editing model files, checking self-collisions, and calculating forward/inverse kinematics. Additionally, you can visualize sensor data, including camera images, point clouds, and forces/torques, on Choreonoid.

![visualization](https://choreonoid.github.io/images/readme/visualization.png)

## Dynamics Simulation

You can simulate the dynamics of robots and environments on Choreonoid. Light-load and accurate simulation environments accelerate your research and development on robot planning and control. Since the default physics engine is robust for contacts, Choreonoid has been utilized in the research on humanoid robots for over a decade.

![simulation](https://choreonoid.github.io/images/readme/dynamics_simulation.png)

(Robot: JAXON by [JSK Laboratory](http://www.jsk.t.u-tokyo.ac.jp/) | Field: from [Humanoid Virtual Athletics Challenge](https://ytazz.github.io/vnoid/) )

## Choreographing

Choreonoid provides a function for choreographing robot motions. Visualization tools and dynamics engines strongly support your motion editing. As an example, Choreonoid enabled the HRP-4C humanoid robot to dance with human dancers in 2010. You can see the video [here](https://www.youtube.com/watch?v=xcZJqiUrbnI).

![choreographing](https://choreonoid.github.io/images/readme/kickmotionsample.jpg)

## Potential

Choreonoid has been used in various situations. Application examples are shown in the following figures and the fields of application range from research to industry and entertainment. One of the advanced features of Choreonoid is extensibility, so you can easily add your own plugins suitable for your project with plentiful resources provided by both Choreonoid and third parties.

![applications](https://choreonoid.github.io/images/readme/applications.png)

# Installation

To install Choreonoid, please see [the installation page](https://choreonoid.org/en/manuals/latest/install/install.html) on the official document

## ROS Support

ROS (currently, only ROS1) is supported. Please see [our official document](https://choreonoid.org/en/manuals/latest/ros/index.html) to set up Choreonoid with ROS.

# Development

Choreonoid project is led by [Dr. Shin'ichiro Nakaoka](https://github.com/s-nakaoka). After the start of the project in 2006, Choreonoid had been developed at National Institute of Advanced Industrial Science and Technology (AIST), Japan, until 2019. Currently, Choreonoid Inc. maintains this project.

# License

Choreonoid is released under the [MIT License](LICENSE).

# Articles

Choreonoid was presented in the following articles:

- S. Nakaoka, "Choreonoid: Extensible virtual robot environment built on an integrated GUI framework," 2012 IEEE/SICE International Symposium on System Integration (SII), 2012, pp. 79-85, doi: 10.1109/SII.2012.6427350. Best Paper Award (Robotics). [[IEEE Xplore](https://ieeexplore.ieee.org/document/6427350)]
- S. Nakaoka, "Choreonoid: Integrated Extensible GUI Environment for Robots," Journal of the Robotics Society of Japan, 2013, Vol. 31, Issue 3, pp. 226-231, 2013 doi: 10.7210/jrsj.31.226, *written in Japanese*. [[J-STAGE](https://www.jstage.jst.go.jp/article/jrsj/31/3/31_31_226/_article/-char/en)]

Please refer to and/or cite them as necessary.
